/*
 * Decompiled with CFR 0.152.
 */
package net.ftb.gui.dialogs;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.Spring;
import javax.swing.SpringLayout;
import net.ftb.data.Map;
import net.ftb.data.ModPack;
import net.ftb.gui.LaunchFrame;
import net.ftb.gui.dialogs.SearchDialog;
import net.ftb.gui.panes.MapUtils;
import net.ftb.locale.I18N;
import net.ftb.util.SwingUtils;

public class MapFilterDialog
extends JDialog {
    private JLabel typeLbl;
    private JComboBox type;
    private JLabel originLbl;
    private JComboBox origin;
    private JLabel compatiblePackLbl;
    private JComboBox compatiblePack;
    private JButton apply;
    private JButton cancel;
    private JButton search;
    private MapUtils pane;

    public MapFilterDialog(MapUtils instance) {
        super((Frame)LaunchFrame.getInstance(), true);
        this.pane = instance;
        this.setupGui();
        this.getRootPane().setDefaultButton(this.apply);
        this.pane = instance;
        this.type.setSelectedItem(MapUtils.type);
        this.origin.setSelectedItem(MapUtils.origin);
        this.compatiblePack.setSelectedItem(MapUtils.compatible);
        ArrayList<String> packs = new ArrayList<String>();
        this.compatiblePack.addItem("All");
        packs.add("All");
        for (int i = 0; i < Map.getMapArray().size(); ++i) {
            String[] compat;
            for (String compatable : compat = Map.getMap(i).getCompatible()) {
                if (compatable.isEmpty() || packs.contains(ModPack.getPack(compatable.trim()).getName())) continue;
                packs.add(ModPack.getPack(compatable.trim()).getName());
                this.compatiblePack.addItem(ModPack.getPack(compatable.trim()).getName());
            }
        }
        this.type.setModel(new DefaultComboBoxModel<String>(new String[]{"Client", "Server"}));
        this.origin.setModel(new DefaultComboBoxModel<String>(new String[]{I18N.getLocaleString("MAIN_ALL"), "FTB", I18N.getLocaleString("FILTER_3THPARTY")}));
        this.compatiblePack.setModel(new DefaultComboBoxModel<Object>(packs.toArray()));
        this.apply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MapFilterDialog.this.pane;
                MapUtils.compatible = (String)MapFilterDialog.this.compatiblePack.getSelectedItem();
                MapFilterDialog.this.pane;
                MapUtils.type = (String)MapFilterDialog.this.type.getSelectedItem();
                MapFilterDialog.this.pane;
                MapUtils.origin = (String)MapFilterDialog.this.origin.getSelectedItem();
                MapFilterDialog.this.pane;
                MapUtils.updateFilter();
                MapFilterDialog.this.setVisible(false);
            }
        });
        this.cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MapFilterDialog.this.setVisible(false);
            }
        });
        this.search.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SearchDialog sd = new SearchDialog(MapFilterDialog.this.pane);
                sd.setVisible(true);
                MapFilterDialog.this.setVisible(false);
            }
        });
    }

    private void setupGui() {
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/image/logo_ftb.png")));
        this.setTitle(I18N.getLocaleString("FILTER_TITLE"));
        this.setResizable(false);
        Container panel = this.getContentPane();
        SpringLayout layout = new SpringLayout();
        panel.setLayout(layout);
        this.originLbl = new JLabel(I18N.getLocaleString("FILTER_ORIGIN"));
        this.typeLbl = new JLabel(I18N.getLocaleString("FILTER_PACKTYPE"));
        this.compatiblePackLbl = new JLabel(I18N.getLocaleString("FILTER_COMPERTIBLEPACK"));
        this.origin = new JComboBox();
        this.type = new JComboBox();
        this.compatiblePack = new JComboBox();
        this.apply = new JButton(I18N.getLocaleString("FILTER_APPLY"));
        this.cancel = new JButton(I18N.getLocaleString("MAIN_CANCEL"));
        this.search = new JButton(I18N.getLocaleString("FILTER_SEARCHMAP"));
        this.origin.setPrototypeDisplayValue("xxxxxxxxxxxxxxxxxxxxxxxxxx");
        this.type.setPrototypeDisplayValue("xxxxxxxxxxxxxxxxxxxxxxxxxx");
        this.compatiblePack.setPrototypeDisplayValue("xxxxxxxxxxxxxxxxxxxxxxxxxx");
        panel.add(this.typeLbl);
        panel.add(this.type);
        panel.add(this.originLbl);
        panel.add(this.origin);
        panel.add(this.compatiblePackLbl);
        panel.add(this.compatiblePack);
        panel.add(this.apply);
        panel.add(this.cancel);
        panel.add(this.search);
        Spring hSpring = Spring.constant(10);
        layout.putConstraint("West", (Component)this.typeLbl, hSpring, "West", (Component)panel);
        layout.putConstraint("West", (Component)this.originLbl, hSpring, "West", (Component)panel);
        layout.putConstraint("West", (Component)this.compatiblePackLbl, hSpring, "West", (Component)panel);
        Spring columnWidth = SwingUtils.springMax(Spring.width(this.typeLbl), Spring.width(this.originLbl), Spring.width(this.compatiblePackLbl));
        hSpring = SwingUtils.springSum(hSpring, columnWidth, Spring.constant(10));
        layout.putConstraint("West", (Component)this.type, hSpring, "West", (Component)panel);
        layout.putConstraint("West", (Component)this.origin, hSpring, "West", (Component)panel);
        layout.putConstraint("West", (Component)this.compatiblePack, hSpring, "West", (Component)panel);
        columnWidth = SwingUtils.springMax(Spring.width(this.type), Spring.width(this.origin), Spring.width(this.compatiblePack));
        hSpring = Spring.sum(hSpring, columnWidth);
        layout.putConstraint("East", (Component)this.type, hSpring, "West", (Component)panel);
        layout.putConstraint("East", (Component)this.origin, hSpring, "West", (Component)panel);
        layout.putConstraint("East", (Component)this.compatiblePack, hSpring, "West", (Component)panel);
        hSpring = Spring.sum(hSpring, Spring.constant(10));
        layout.putConstraint("East", (Component)panel, hSpring, "West", (Component)panel);
        layout.putConstraint("West", (Component)this.search, 10, "West", (Component)panel);
        layout.putConstraint("East", (Component)this.search, -5, "HorizontalCenter", (Component)panel);
        layout.putConstraint("West", (Component)this.cancel, 5, "HorizontalCenter", (Component)panel);
        layout.putConstraint("East", (Component)this.cancel, -10, "East", (Component)panel);
        layout.putConstraint("West", (Component)this.apply, 10, "West", (Component)panel);
        layout.putConstraint("East", (Component)this.apply, -10, "East", (Component)panel);
        Spring vSpring = Spring.constant(10);
        layout.putConstraint("Baseline", (Component)this.typeLbl, 0, "Baseline", (Component)this.type);
        layout.putConstraint("North", (Component)this.type, vSpring, "North", (Component)panel);
        Spring rowHeight = Spring.max(Spring.height(this.typeLbl), Spring.height(this.type));
        vSpring = SwingUtils.springSum(vSpring, rowHeight, Spring.constant(5));
        layout.putConstraint("Baseline", (Component)this.originLbl, 0, "Baseline", (Component)this.origin);
        layout.putConstraint("North", (Component)this.origin, vSpring, "North", (Component)panel);
        rowHeight = Spring.max(Spring.height(this.originLbl), Spring.height(this.origin));
        vSpring = SwingUtils.springSum(vSpring, rowHeight, Spring.constant(5));
        layout.putConstraint("Baseline", (Component)this.compatiblePackLbl, 0, "Baseline", (Component)this.compatiblePack);
        layout.putConstraint("North", (Component)this.compatiblePack, vSpring, "North", (Component)panel);
        rowHeight = Spring.height(this.compatiblePackLbl);
        rowHeight = Spring.max(rowHeight, Spring.height(this.compatiblePack));
        vSpring = SwingUtils.springSum(vSpring, rowHeight, Spring.constant(10));
        layout.putConstraint("North", (Component)this.search, vSpring, "North", (Component)panel);
        layout.putConstraint("North", (Component)this.cancel, vSpring, "North", (Component)panel);
        rowHeight = Spring.max(Spring.height(this.search), Spring.height(this.cancel));
        vSpring = SwingUtils.springSum(vSpring, rowHeight, Spring.constant(5));
        layout.putConstraint("North", (Component)this.apply, vSpring, "North", (Component)panel);
        vSpring = SwingUtils.springSum(vSpring, Spring.height(this.apply), Spring.constant(10));
        layout.putConstraint("South", (Component)panel, vSpring, "North", (Component)panel);
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }
}

